# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.conf import settings

from rasp_vault.api import get_secret
from travel.rasp.library.python.sqs.wrapper import SQSClientWrapper

from common.settings.configuration import Configuration
from common.settings.utils import define_setting


define_setting('SQS_ACCESS_KEY', {
    Configuration.PRODUCTION: 'rasp',
    Configuration.TESTING: 'rasp-test'
}, default='rasp-dev')

define_setting('SQS_ENABLE_WRITING', {
    Configuration.PRODUCTION: True,
    Configuration.TESTING: True,
}, default=False)

define_setting('SQS_SECRET_KEY', default='not-used-yet')
define_setting('SQS_OAUTH_TOKEN', default=lambda: get_secret('rasp-common.SQS_OAUTH_TOKEN'))
define_setting('SQS_ENDPOINT', default='http://sqs.yandex.net:8771')
define_setting('SQS_READ_TIMEOUT', default=10)
define_setting('SQS_CONNECT_TIMEOUT', default=1)
define_setting('SQS_RETRIES_MAX_ATTEMPTS', default=1)


sqs_client = SQSClientWrapper(
    aws_access_key_id=settings.SQS_ACCESS_KEY,
    aws_secret_access_key=settings.SQS_SECRET_KEY,
    aws_session_token=settings.SQS_OAUTH_TOKEN,
    endpoint_url=settings.SQS_ENDPOINT,
    connect_timeout=settings.SQS_CONNECT_TIMEOUT,
    read_timeout=settings.SQS_READ_TIMEOUT,
    retries=settings.SQS_RETRIES_MAX_ATTEMPTS,
    enable_writing=settings.SQS_ENABLE_WRITING
)
