# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.decorators import classonlymethod


def swagger_aware_view_set(klass):
    class _SwaggerAwareViewSet(klass):
        @classonlymethod
        def as_view(cls, actions=None, **kwargs):
            view = klass.as_view(actions, **kwargs)
            view.actions = actions
            # здесь не должно быть разных cb_name, но с другой стороны actions - dict
            for method, cb_name in actions.items():
                if getattr(klass, cb_name).__doc__:
                    view.__doc__ = getattr(klass, cb_name).__doc__
                    break

            return view
    _SwaggerAwareViewSet.__name__ = klass.__name__
    return _SwaggerAwareViewSet
