# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta

from common.settings.utils import define_setting

define_setting('EMAIL_SENDER_NUMBER_TO_PROCESS_PER_LAUNCH', default=50)
define_setting('EMAIL_SENDER_WAIT_INTERVAL', default=timedelta(minutes=10))
define_setting('EMAIL_SENDER_CONCURRENT_PROCESSING', default=False)
define_setting('EMAIL_SENDER_DB_ALIAS', default='default')
define_setting('EMAIL_SENDER_MAX_ALLOWED_TIME_IN_QUEUE', default=timedelta(days=1))

# В качестве callback можно задавать как callable так и путь до callable
define_setting('EMAIL_SENDER_CALLBACK_ON_MAX_ALLOWED_TIME_IN_QUEUE_EXCEEDED', default=lambda: lambda email_intent_object: None)

# Импорты после настроек, потому что модули используют настройки
from .models import EmailIntent, AttachmentInfo  # noqa
from .sender import guaranteed_send_email  # noqa
from .tasks import run_queue  # noqa
