# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import factory
from factory.mongoengine import MongoEngineFactory

from common.utils import gen_hex_uuid

from .models import EmailIntent, AttachmentInfo


class EmailIntentFactory(MongoEngineFactory):
    class Meta:
        model = EmailIntent

    key = factory.LazyFunction(gen_hex_uuid)
    email = 'losos@example.org'
    args = {'foo': 'bar'}
    campaign_code = factory.Faker('first_name')


class AttachmentInfoFactory(MongoEngineFactory):
    class Meta:
        model = AttachmentInfo

    filename = 'notes.txt'
    mime_type = 'text/plain'
    content = b'pam-param'
