# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


"""
Конфиг гуникорна, который в фоне синхронизирует файлы из MDS на диск
"""


mds_syncer = None


def on_starting(server):
    from django.conf import settings
    from common.db.mds.syncer import MdsSyncer

    global mds_syncer
    mds_syncer = MdsSyncer(settings.MDS_SYNCER_CONFIG, settings.MDS_SYNCER_CHECK_INTERVAL)
    mds_syncer.update_files()


def when_ready(server):
    mds_syncer.start()
