# coding: utf8
from __future__ import unicode_literals

from lxml import etree

from travel.rasp.library.python.common23.date import environment
from common.utils.fields import DatabaseFileField
from django.core.exceptions import ValidationError
from django.db import models
from django.utils.translation import ugettext_lazy as _
from travel.rasp.library.python.common23.models.core.geo.express2country import Express2Country  # noqa


def _is_xml_validator(file_obj):
    try:
        etree.parse(file_obj)
    except Exception as e:
        raise ValidationError(u"Файл не является xml: %s" % unicode(e))
    finally:
        file_obj.seek(0)


def _get_year_choices():
    current_year = environment.today().year
    years = range(current_year - 2, current_year + 3)

    return [(year, year) for year in years]


class YaCalendarXml(models.Model):
    country = models.ForeignKey('www.Country', null=False, verbose_name=_(u"Страна"))
    year = models.IntegerField(_(u"Год"), null=False, choices=_get_year_choices())
    xml_file = DatabaseFileField(_(u"Файл пакета"), content_type='text/xml',
                                 validators=[_is_xml_validator])

    def __unicode__(self):
        return _(u"Календарь выходных дней %s за %s") % (self.country.title, self.year)

    def get_year(self):
        return self.year

    class Meta:
        app_label = 'importinfo'
        verbose_name = _(u"Электрички: Копия календаря")
        verbose_name_plural = _(u"Электрички: Копии календаря")
        unique_together = (('country', 'year'),)
        ordering = ('country', '-year',)
