# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import six
from django.db import models
from django.utils.translation import ugettext_lazy as _

from common.utils.fields import CodeCharField


@six.python_2_unicode_compatible
class BuscomuaStationCode(models.Model):
    server_code = CodeCharField(_(u"Код сервера"), max_length=100, blank=False, null=False, default=u"")
    city_code = CodeCharField(_(u"Код города"), max_length=100, blank=False, null=False, default=u"")
    station_code = CodeCharField(_(u"Код станции"), max_length=100, blank=False, null=False, default=u"")
    station = models.ForeignKey('www.Station', null=False)

    def __str__(self):
        return six.text_type(_(u"Код станции {} {} {} {}")).format(
            self.station.id, self.station.title,
            self.city_code,
            self.station_code,
        )

    class Meta:
        app_label = 'importinfo'
        unique_together = (('server_code', 'city_code', 'station_code', 'station'),)
        verbose_name = _(u"Код станции")
        verbose_name_plural = _(u"БусКомУа: Коды станции")
