from subprocess import call

from django.conf import settings
from django.core.management import BaseCommand


class Command(BaseCommand):
    def handle(self, *args, **options):
        command = (
            'celery multi start {app_name} '
            '--app={app} '
            '--loglevel=DEBUG '
            '--logfile=log/%n.log '
            '--pidfile={app_name}.pid'
        ).format(app_name=settings.CELERY_DEV_APP_NAME, app=settings.CELERY_DEV_APP_MODULE)
        call(command.split(' '))
