# -*- coding: utf-8 -*-
import runpy
import sys

from django.core.management import BaseCommand


class Command(BaseCommand):
    def handle(self, *args, **options):
        # В запускаемом скрипте sys.argv будет без
        # первых двух аругментов './manage.py', 'run_path'
        sys.argv = list(args)

        runpy.run_path(args[0], run_name='__main__')

    def run_from_argv(self, argv):
        # Переопределям стандартный run_from_argv
        # чтобы не парсить args
        self.execute(*argv[2:])
