# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.utils.blackbox_wrapper import get_session_for_request, SessionInsecure, SessionNoauth, SessionInvalid
from common.utils.ya import auth_response_redirect


class BlackboxSessionMiddleware(object):
    """
    Зависит от common.middleware.uatraits_detector.UatraitsDetectorMiddleware и
    common.geotargeting.middleware.Ip (либо common.geotargeting.middleware.GeoTargeting)
    """
    def process_request(self, request):
        request.blackbox_session = None
        if request.uatraits_result.get('isRobot'):
            return

        try:
            request.blackbox_session = blackbox_session = get_session_for_request(request, userip=request.client_ip)
        except SessionInsecure:
            # если пользователь не залогинен по https или это лайт-авторизация, то синхронизация кук не поможет
            return
        except SessionNoauth:
            # если сессия имеет статус NOAUTH, то ничего делать не нужно
            return
        except SessionInvalid:
            # если пользователь не залогинен
            return
        else:
            # если сессия имеет статус NEED_RESET, то синхронизируем или продлеваем куки
            if not blackbox_session:
                return
            if not blackbox_session.redirect:
                return

            # если среди GET-параметров имеется nocookiesupport=yes, то куки выключены, и авторизация работать не будет
            if request.GET.get('nocookiesupport') == 'yes':
                return

            return auth_response_redirect(request)
