# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from common.utils import request_helper


class Host:
    def process_request(self, request):
        request.host = request_helper.get_host(request)
        request.port = ''

        if ':' in request.host:
            request.host, port = request.host.rsplit(':', 1)
            request.port = ':' + port

        request.root_domain = 'ru'

        if '.' in request.host:
            request.root_domain = request.host.rsplit('.', 1)[1]

        request.tld = 'ru'

        for tld in ['ru', 'by', 'kz', 'uz', 'ua', 'com', 'com.tr']:
            if request_helper.get_host(request).endswith('.' + tld):
                request.tld = tld
                break
