import warnings

from django.conf import settings
from django.http import HttpResponseRedirect
from django.utils import translation

from common.utils import request_helper
from common.utils.locations import langify
from common.utils.warnings import RaspDeprecationWarning
from common.utils.ya import detect_lang


class LanguageMiddleware(object):
    def process_request(self, request):
        domain_lang, supported_langs = self._get_domain_lang_and_supported_langs(request)
        request.supported_langs = supported_langs
        request.domain_lang = domain_lang

        lang_from_url = request.GET.get('lang')
        if lang_from_url in supported_langs:
            lang = lang_from_url
        elif request.uatraits_result.get('isRobot'):
            lang = domain_lang
        else:
            lang = detect_lang(request, domain_lang=domain_lang, supported_langs=supported_langs)
            if lang != domain_lang:
                return HttpResponseRedirect(langify(request_helper.build_absolute_uri(request), lang))

        translation.activate(lang)
        request.LANGUAGE_CODE = translation.get_language()

    def _get_domain_lang_and_supported_langs(self, request):
        return settings.DOMAIN_LANGUAGE_MAP.get(request.NATIONAL_VERSION, settings.DOMAIN_LANGUAGE_MAP['ru'])


class Language(object):
    def __init__(self):
        warnings.warn('[2016-08-09] Use LanguageMiddleware', RaspDeprecationWarning, stacklevel=2)

    def process_request(self, request):
        lang, request.supported_langs = settings.DOMAIN_LANGUAGE_MAP['ru']

        request.domain_lang = lang

        if 'lang' in request.GET:
            lang = request.GET['lang']

        elif 'locale' in request.GET:
            lang = request.GET['locale']

        else:
            if request.path.startswith('/admin/'):
                if request.tld == 'ru':
                    request.maps_language = 'ru'
                    lang = 'ru'

                else:
                    lang = 'en'

                    if request.tld == 'com.tr':
                        request.maps_language = 'tr'

                    else:
                        request.maps_language = 'en'

            else:
                for domain, (domain_lang, supported_langs) in settings.DOMAIN_LANGUAGE_MAP.items():
                    if request.host == domain or request.host.endswith('.' + domain):
                        request.supported_langs = supported_langs

                        request.domain_lang = domain_lang

                        lang = detect_lang(request)

                        break

        translation.activate(lang)

        request.LANGUAGE_CODE = translation.get_language()

        translation.marktrans = request.GET.get('marktrans')
