# coding: utf8

from datetime import datetime

from django.http import HttpResponseBadRequest

from travel.rasp.library.python.common23.date import environment
from travel.rasp.library.python.common23.date.date_const import MSK_TZ
from travel.rasp.library.python.common23.date.environment import set_time_context, delete_time_context


class Now(object):
    time_format = '%Y-%m-%d %H:%M'

    def process_request(self, request):
        freeze_now = None
        if request.GET.get('_now'):
            try:
                freeze_now = datetime.strptime(request.GET['_now'], self.time_format)
            except ValueError:
                return HttpResponseBadRequest(u'Параметр _now имеет невалидный формат. '
                                              u'Правильный формат: {}.'.format(self.time_format),
                                              content_type='text/plain; charset=utf-8')
        if freeze_now:
            set_time_context(freeze_now)

        # FIXME: Нужно вынести установку now на request в отдельную миддлевару
        now = environment.now()
        request.msk_now = MSK_TZ.localize(now)
        request.now = request.msk_now
        request.naive_msk_now = request.msk_now.replace(tzinfo=None)

    def del_time_from_context(self, request):
        if request.GET.get('_now'):
            delete_time_context()

    def process_response(self, request, response):
        self.del_time_from_context(request)
        return response

    def process_exception(self, request, exception):
        self.del_time_from_context(request)
