# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.encoding import smart_text


class RobotDetector:
    """Проверяет, не яндексовый паук ли это пожаловал"""

    OLD_YANDEX = set([
        'Yandex/1.01.001 (compatible; Win16; I)',
        'Yandex/1.01.001 (compatible; Win16; P)',
        'Yandex/1.01.001 (compatible; Win16; H)',
        'Yandex/1.02.000 (compatible; Win16; F)',
        'Yandex/1.03.003 (compatible; Win16; D)',
        'Yandex/1.01.001 (compatible; Win16; m)',
        'Yandex/1.03.000 (compatible; Win16; M)',
        'YaDirectBot/1.0 (compatible; Win16; I)',
        'YandexBlog/0.99.101 (compatible; DOS3.30; Mozilla/5.0; B; robot)',
        'Yandex/2.01.000 (compatible; Win16; Dyatel; C)',
        'Yandex/2.01.000 (compatible; Win16; Dyatel; Z)',
        'Yandex/2.01.000 (compatible; Win16; Dyatel; D)',
        'Yandex/2.01.000 (compatible; Win16; Dyatel; N)',
        'rasp_check_spider',
    ])

    YANDEX = set([
        'YandexBot',
        'YandexImages',
        'YandexVideo',
        'YandexMedia',
        'YandexBlogs',
        'YandexAddurl',
        'YandexFavicons',
        'YandexDirect',
        'YandexMetrika',
        'YandexCatalog',
        'YandexNews',
        'rasp_check_spider',
    ])

    def is_yandex(self, user_agent):
        if user_agent in self.OLD_YANDEX:
            return True

        if '/' in user_agent:
            main = user_agent.split('/', 1)[0]

            if main in self.YANDEX:
                return True

        return False

    def process_request(self, request):
        user_agent = smart_text(request.META.get('HTTP_USER_AGENT'))

        request.yandex_bot = user_agent and self.is_yandex(user_agent)
