# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.contrib.auth.middleware import AuthenticationMiddleware
from django.contrib.auth.models import User, AnonymousUser

from common.data_api.tvm.instance import tvm_factory
from common.settings.utils import define_setting
from common.utils.blackbox_wrapper import get_session_for_request, SessionInvalid, SessionError


define_setting('YATEAM_LOGIN_ENABLED', default=True)


class YaTeamUserAuth(AuthenticationMiddleware):
    """ Логинимся через yandex-team.ru (blackbox должен быть на yandex-team.ru).
        Внутренний блэкбокс не возвращает staff_user, как при логине через обычный паспорт,
        а просто поле login == staff_user
    """

    def process_request(self, request):
        if not settings.YATEAM_LOGIN_ENABLED:
            return super(YaTeamUserAuth, self).process_request(request)

        request.user = AnonymousUser()

        tvm_ticket = tvm_factory.get_provider().get_ticket(settings.TVM_BLACKBOX_YATEAM)

        try:
            blackbox_session = get_session_for_request(request, blackbox_url=settings.BLACKBOX_URL_YATEAM,
                                                       tvm_ticket=tvm_ticket)
        except (SessionInvalid, SessionError):
            return

        if blackbox_session:
            try:
                request.user = User.objects.get(username=blackbox_session.fields['login'])
            except User.DoesNotExist:
                pass
