# -*- coding: utf-8 -*-

import warnings

from django.conf import settings
from django.contrib.auth.models import User, AnonymousUser

from common.utils.warnings import RaspDeprecationWarning
from common.utils.ya import make_secret_key


class YandexUser(object):
    """
    Модель яндексового пользователя.
    """
    def __init__(self, uid, fields):
        self.uid = uid
        self.lang = fields.get('lang')
        self.login = fields.get('login')
        self.staff_login = fields.get('staff_login')
        self._fields = fields

    def is_authenticated(self):
        return True

    def get_django_user(self):
        try:
            return User.objects.get(username=self.staff_login)
        except User.DoesNotExist:
            return AnonymousUser()

    def __str__(self):
        return self.login

    def __getattr__(self, field):
        warnings.warn('[2016-05-10] Use explicit attributes.', RaspDeprecationWarning, stacklevel=2)
        try:
            return self._fields[field]
        except KeyError:
            raise AttributeError(field)

    @property
    def fields(self):
        warnings.warn('[2016-05-10] Use explicit attributes.', RaspDeprecationWarning, stacklevel=2)
        return self._fields


class AnonymousYandexUser(object):
    """
    Заглушка незалогиненного пользователя.
    """
    login = '(Not logged in)'
    staff_login = '(Not logged in)'
    uid = None
    lang = None

    def is_authenticated(self):
        return False

    def __str__(self):
        return self.login

    def get_django_user(self):
        return AnonymousUser()


def get_yauser(request):
    if settings.DISABLE_YAUTH:
        return AnonymousYandexUser()

    if request.uatraits_result.get('isRobot'):
        return AnonymousYandexUser()

    session = request.blackbox_session
    if not session:
        return AnonymousYandexUser()

    # Куки Session_id и session2 (ssl) есть и валидны
    return YandexUser(uid=int(session.uid), fields=session.fields)


class YaUserMiddleware(object):
    def process_request(self, request):
        request.yauser = get_yauser(request)
        request.secret_key = make_secret_key(request)
