# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _


class RouteUidMap(models.Model):
    new_uid = models.CharField(verbose_name=_(u'Старый uid маршрута'), max_length=100, null=False, db_index=True)
    old_uid = models.CharField(verbose_name=_(u'Новый uid маршрута'), max_length=100, null=False, db_index=True)

    class Meta:
        verbose_name = _(u'Соответствие старого и нового uid-ов маршрута')
        verbose_name_plural = _(u'Соответствие старых и новых uid-ов маршрутов')
        app_label = 'www'


class RThreadUidMap(models.Model):
    new_uid = models.CharField(verbose_name=_(u'Старый uid нитки'), max_length=100, null=False, db_index=True)
    old_uid = models.CharField(verbose_name=_(u'Новый uid нитки'), max_length=100, null=False, db_index=True)

    class Meta:
        verbose_name = _(u'Соответствие старого и нового uid-ов нитки')
        verbose_name_plural = _(u'Соответствие старых и новых uid-ов ниток')
        app_label = 'www'
