# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta

from common.apps.info_center.models import Info, ObjectLink
from common.models.schedule import PlatformTranslation
from common.models.teasers import Page
from travel.rasp.library.python.common23.date import environment
from travel.rasp.library.python.common23.models.tariffs.tester.factories import (  # noqa
    create_aeroex_tariff, create_tariff_group, create_tariff_type,
    AeroexTariff, TariffGroup, TariffType
)
from travel.rasp.library.python.common23.tester.factories import (  # noqa
    create_settlement, create_external_direction, ModelFactory, factories, create_station, BaseFactory
)


class InfoFactory(BaseFactory):
    default_kwargs = {
        'title': 'Тизер',
        'text': 'Текст длинный',
        'text_short': 'Текст короткий',
        'dt_from': lambda: environment.now() - timedelta(100),
        'dt_to': lambda: environment.now() + timedelta(3000),
        'national_versions': ['ru'],
        'lang': u'ru',
        'info_type': Info.Type.NORMAL,
        'importance': 0,
        'services': [Info.Service.WEB],
    }

    def create_object(self, kwargs):
        pages = kwargs.pop('pages', [])
        stations = kwargs.pop('stations', [])
        settlements = kwargs.pop('settlements', [])
        external_directions = kwargs.pop('external_directions', [])

        info = Info(**kwargs)
        info.linked_objects = [[]]

        for station_param in stations:
            station = create_station(station_param)
            info.linked_objects[0].append(ObjectLink(obj_type='station', obj_key=station.id))

        for settlement_param in settlements:
            settlement = create_settlement(settlement_param)
            info.linked_objects[0].append(ObjectLink(obj_type='settlement', obj_key=settlement.id))

        for direction_param in external_directions:
            direction = create_external_direction(direction_param)
            info.linked_objects[0].append(ObjectLink(obj_type='externaldirection', obj_key=direction.id))

        for page_param in pages:
            page = create_teaser_page(page_param)
            info.linked_objects[0].append(ObjectLink(obj_type='page', obj_key=page.code))

        info.save()

        return info


create_info = InfoFactory()


class TeaserFactory(BaseFactory):
    """ Фабрика старых тизеров на основе Info """

    default_kwargs = {
        'title': 'Тизер',
        'content': 'Содержимое тизера',
        'date_start': lambda: environment.now() - timedelta(100),
        'date_finish': lambda: environment.now() + timedelta(3000),
        'national_version': 'ru',
        'lang': u'ru',
        'mode': 'normal',
        'importance': 0,
        'services': [],
    }

    def create_object(self, kwargs):
        if kwargs.get('is_active_export'):
            kwargs['services'].append(Info.Service.MOBILE_APPS)

        if kwargs.get('is_active_rasp'):
            kwargs['services'].append(Info.Service.WEB)

        info = create_info(
            id=kwargs.get('id'),
            uuid=kwargs.get('uuid'),
            title=kwargs['title'],
            url=kwargs.get('url'),
            text=kwargs['content'],
            text_short=kwargs.get('mobile_content'),
            dt_from=kwargs['date_start'],
            dt_to=kwargs['date_finish'],
            lang=kwargs['lang'],
            national_versions=[kwargs['national_version']],
            info_type=kwargs['mode'],
            importance=kwargs['importance'],
            services=kwargs['services'],
            pages=kwargs.get('pages', []),
            stations=kwargs.get('stations', []),
            settlements=kwargs.get('settlements', []),
            external_directions=kwargs.get('external_directions', []),
        )

        return info.to_old_teaser()


create_teaser = TeaserFactory()


class TeaserPageFactory(ModelFactory):
    Model = Page
    default_kwargs = {
        'title': u'НазваниеСтраницыТизера',
        'code': lambda: TeaserPageFactory.gen_code()
    }

    @classmethod
    def gen_code(cls):
        cls.code_counter = getattr(cls, 'code_counter', 0) + 1
        return u'code{}'.format(cls.code_counter)


create_teaser_page = TeaserPageFactory()
factories[Page] = create_teaser_page


class PlatformTranslationFactory(ModelFactory):
    Model = PlatformTranslation


create_platform_translation = PlatformTranslationFactory()
factories[PlatformTranslation] = create_platform_translation
