# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.db import models
from django.utils.translation import ugettext_lazy as _

from common.models.geo import Settlement

log = logging.getLogger(__name__)


class PathfinderMapsNearestSettlement(models.Model):
    settlement_from = models.ForeignKey(Settlement, verbose_name=_(u'город, который заменяется'),
                                        null=False, blank=False, related_name=u'settlement_from', unique=True)
    settlement_to = models.ForeignKey(Settlement, verbose_name=_(u'город, на который заменяется'),
                                      null=False, blank=False, related_name=u'settlement_to')

    class Meta:
        verbose_name = _(u'ближайший город для pathfinder-maps')
        verbose_name_plural = _(u'ближайшие города для pathfinder-maps')
        app_label = 'www'
        db_table = 'pathfinder_maps_nearest_settlement'
