# coding: utf8
from contextlib import closing

from django.db import models


class Timestamp(models.Model):
    code = models.CharField(null=False, primary_key=True, max_length=16)
    value = models.DateTimeField(null=True)

    @classmethod
    def set(cls, code, value):
        instance = cls.objects.get(code=code)
        instance.value = value
        instance.save()

    @classmethod
    def get(cls, code):
        return cls.objects.get(code=code).value

    @classmethod
    def get_via_connection(cls, code, connection):
        """
        В некоторых случаях приходится получать таймстемп через явно заданное соединение.
        Например, при попытке понять, синхронизированы ли реплики, создаются отдельные соединения для каждого сервера.
        """

        with closing(connection.cursor()) as cursor:
            cursor.execute('SELECT value FROM www_timestamp WHERE code=%s', [code])
            row = cursor.fetchone()
            value = row and row[0]
            return value

    class Meta:
        app_label = 'www'
