# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.fields import TrimmedCharField

from travel.rasp.library.python.common23.models.transport.transport_model import TransportModel  # noqa
from travel.rasp.library.python.common23.models.transport.transport_subtype import TransportSubtype, TransportSubtypeIconField  # noqa
from travel.rasp.library.python.common23.models.transport.transport_subtype_color import TransportSubtypeColor  # noqa
from travel.rasp.library.python.common23.models.transport.transport_type import TransportType, TRANSPORT_TYPES  # noqa


class TrainPseudoStationMap(models.Model):
    number = TrimmedCharField(verbose_name=_(u'номер'), max_length=50)
    pseudo_station = models.ForeignKey('www.Station', verbose_name=_(u'псевдостанция'),
                                       related_name='pseudo_pseudo_station_set')
    station = models.ForeignKey('www.Station', verbose_name=_(u'станция'), related_name='pseudo_station_set')

    class Meta:
        verbose_name = _(u'замена псевдостанции')
        verbose_name_plural = _(u'замены псевдостанций')
        app_label = 'www'
        unique_together = (('number', 'station'),)
