# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.db import models
from django.utils.translation import ugettext_lazy as _


class StationTeleportMap(models.Model):
    station_from = models.ForeignKey('Station', verbose_name=_(u'станция от'), blank=True, null=True,
                                     related_name='station_teleport_map_from')
    settlement_from = models.ForeignKey('Settlement', verbose_name=_(u'город от'), blank=True, null=True,
                                        related_name='station_teleport_map_from')
    station_to = models.ForeignKey('Station', verbose_name=_(u'станция до'), blank=True, null=True,
                                   related_name='station_teleport_map_to')
    settlement_to = models.ForeignKey('Settlement', verbose_name=_(u'город до'), blank=True, null=True,
                                      related_name='station_teleport_map_to')
    teleport_time = models.IntegerField(verbose_name=_(u'время на пересадку'), help_text=_(u'в минутах (целое число)'))

    def __unicode__(self):
        point_from = u''
        if self.station_from:
            point_from = self.station_from.title
        elif self.settlement_from:
            point_from = self.settlement_from.title

        point_to = u''
        if self.station_to:
            point_to = self.station_to.title
        elif self.settlement_to:
            point_to = self.settlement_to.title

        return u'%s %s %s' % (point_from, point_to, self.teleport_time)

    class Meta:
        verbose_name = _(u'связь между станциями')
        verbose_name_plural = _(u'связи между станциями')
        app_label = 'www'
