from travel.rasp.library.python.common23.models.utils import *  # noqa

from common.xgettext.i18n import dynamic_gettext


class DisplayTCodeMixin(object):
    @property
    def display_t_code(self):
        if getattr(self, 'thread', None):
            if self.thread.is_express:
                return 'express'

            if self.thread.is_aeroexpress:
                return 'aeroexpress'

        if getattr(self, 't_model', None):
            return self.t_model.t_type.code

        if getattr(self, 't_type', None):
            return self.t_type.code

        return self.thread.t_type.code

    @classmethod
    def t_code_name(self, code):
        from common.models.transport import TRANSPORT_TYPES

        source_name = TRANSPORT_TYPES.get(code)

        if source_name:
            return dynamic_gettext(source_name)

        return None

