PY2TEST()
OWNER(g:rasp-back)

SIZE(MEDIUM)
NO_CHECK_IMPORTS()
REQUIREMENTS(ram:12)

INCLUDE(${ARCADIA_ROOT}/travel/rasp/library/python/common23/dev/rasp_tests.inc)

PEERDIR(
    contrib/python/httpretty
    contrib/python/gunicorn
    contrib/python/freezegun
    contrib/python/PyHamcrest

    travel/rasp/library/python/common
    travel/rasp/library/python/route_search
    travel/rasp/library/python/geosearch

    travel/rasp/library/python/common23/tester
    travel/rasp/library/python/common23/tester/full_settings
    travel/rasp/library/python/common23/tester/plugins_models
)

PY_SRCS(
    conftest.py
)

PY_SRCS(
    NAMESPACE common.tests
    utils/__init__.py
    dev_tools/swagger/spec.py
    middleware/request_factory.py
)

TEST_SRCS(
    apps/__init__.py
    apps/archival_data/test_api.py
    apps/archival_data/test_generation.py
    apps/facilities/__init__.py
    apps/facilities/test_shortcuts.py
    apps/im_logs/test_models.py
    apps/info_center/__init__.py
    apps/info_center/test_getter.py
    apps/info_center/test_models.py
    apps/info_center/test_push.py
    apps/suburban_events/__init__.py
    apps/suburban_events/forecast/__init__.py
    apps/suburban_events/forecast/test_events.py
    apps/suburban_events/forecast/test_fact_interpolation.py
    apps/suburban_events/forecast/test_forecast.py
    apps/suburban_events/forecast/test_match_cppk.py
    apps/suburban_events/forecast/test_match_rzd.py
    apps/suburban_events/scripts/__init__.py
    apps/suburban_events/scripts/test_precalc_thread_events.py
    apps/suburban_events/scripts/test_update_companies_crashes.py
    apps/suburban_events/scripts/test_update_movista_matched_cancels.py
    apps/suburban_events/scripts/test_update_movista_raw_cancels.py
    apps/suburban_events/test_api.py
    apps/suburban_events/test_logs.py
    apps/suburban_events/test_utils.py
    apps/train/__init__.py
    apps/train/models/__init__.py
    apps/train/models/place_price_rules/__init__.py
    apps/train/models/place_price_rules/test_clean.py
    apps/train/models/place_price_rules/test_coach_number.py
    apps/train/models/place_price_rules/test_owner.py
    apps/train/models/place_price_rules/test_place_numbers.py
    apps/train/models/place_price_rules/test_train_number.py
    apps/train/models/test_service_class.py
    apps/train/models/test_tariffinfo.py
    apps/train/models/test_ufsneworderblacklist.py

    celery/test_task.py

    data_api/__init__.py
    data_api/baris/__init__.py
    data_api/baris/test_all_flights.py
    data_api/baris/test_helpers.py
    data_api/baris/test_service.py
    data_api/billing/__init__.py
    data_api/billing/test_helpers.py
    data_api/billing/test_trust_client.py
    data_api/dzv/__init__.py
    data_api/dzv/test_platform_replace.py
    data_api/file_wrapper/test_config.py
    data_api/file_wrapper/test_wrapper.py
    data_api/min_prices/__init__.py
    data_api/min_prices/test_api.py
    data_api/platforms/__init__.py
    data_api/platforms/test_client.py
    data_api/platforms/test_helpers.py
    data_api/sandbox/__init__.py
    data_api/sandbox/test_remote_copy_resource_task_runner.py
    data_api/sandbox/test_sandbox_task_runner.py
    data_api/search_stats/__init__.py
    data_api/search_stats/test_search_stats.py
    data_api/search_stats/test_search_stats_saver.py
    data_api/sendr/__init__.py
    data_api/sendr/test_api.py
    data_api/sup/__init__.py
    data_api/sup/test_client.py
    data_api/ticket_daemon/__init__.py
    data_api/ticket_daemon/serialization/__init__.py
    data_api/ticket_daemon/serialization/test_segment.py
    data_api/ticket_daemon/serialization/test_variant.py
    data_api/ticket_daemon/test_async_api.py
    data_api/ticket_daemon/test_query.py
    data_api/train_api/__init__.py
    data_api/train_api/tariffs/__init__.py
    data_api/train_api/tariffs/test_utils.py
    data_api/travelers/__init__.py
    data_api/travelers/test_client.py
    data_api/url_shortener/__init__.py
    data_api/url_shortener/test_client.py
    data_api/yandex_bus/__init__.py
    data_api/yandex_bus/test_api.py
    data_api/yasms/__init__.py
    data_api/yasms/test_client.py

    db/kikimr/conftest.py
    db/kikimr/test_client.py
    db/kikimr/test_schedule_conf.py
    db/mongo/__init__.py
    db/mongo/test_bulk_buffer.py
    db/mongo/test_counter.py
    db/mongo/test_fields.py

    dev_tools/__init__.py
    dev_tools/swagger/__init__.py
    dev_tools/swagger/test_decorator.py
    dev_tools/swagger/test_endpoint.py
    dev_tools/swagger/test_spec.py
    dev_tools/swagger/test_view.py

    email_sender/__init__.py
    email_sender/test_models.py
    email_sender/test_sender.py
    email_sender/test_tasks.py

    geotargeting/__init__.py
    geotargeting/test_lookup.py
    geotargeting/test_middleware.py

    middleware/__init__.py
    middleware/test_blackbox_session.py
    middleware/test_client_city.py
    middleware/test_geotargeting.py
    middleware/test_ip.py
    middleware/test_language.py
    middleware/test_language_middleware.py
    middleware/test_locale_request.py
    middleware/test_now.py
    middleware/test_uatraits_detector.py
    middleware/test_yateamuser.py
    middleware/test_yauser.py
    middleware/yandexuid/__init__.py
    middleware/yandexuid/test_need_new_yandexuid.py
    middleware/yandexuid/test_process_request.py
    middleware/yandexuid/test_process_response.py

    models/__init__.py
    models/test_staticpages.py
    models/test_timestamp.py

    models_admin/__init__.py
    models_admin/test_route_path.py

    utils/test_blablacar_utils.py

    utils/date/test_date_run_days.py
    utils/django_utils/__init__.py
    utils/django_utils/test_utf8_json_serializer.py

    utils/test_admindumps.py
    utils/test_bemhtml_template.py
    utils/test_blackbox.py
    utils/test_field_masker.py
    utils/test_httpcaching.py
    utils/test_lock.py
    utils/test_lxmlutils.py
    utils/test_marketstat.py
    utils/test_multiproc.py
    utils/test_qloud_urls.py
    utils/test_railway.py
    utils/test_request_limiter.py
    utils/test_settlement.py
    utils/test_settlement_stations.py
    utils/test_settlement_ymap_url.py
    utils/test_subprocess.py
    utils/test_tanker.py
    utils/test_try_hard.py
    utils/test_unicode_csv.py
    utils/test_yasmutil.py
    utils/ya/__init__.py
    utils/ya/test_auth_response_redirect.py

    views/__init__.py
    views/test_currency.py
    views/test_teasers.py
    views/test_thread.py
    views/test_version.py

    workflow/__init__.py
    workflow/test_locker.py
    workflow/test_process.py
    workflow/test_registry.py
    workflow/test_reviver.py
    workflow/test_scheme.py
    workflow/test_sleep.py
    workflow/test_utils.py
)

END()
