# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.http import QueryDict
from six.moves.urllib_parse import quote


def get_avia_thread_url(thread, tld, day=None, utm_medium=None, utm_campaign=None):
    host = settings.NATIONAL_AVIA_DOMAINS.get(tld, settings.NATIONAL_AVIA_DOMAINS['ru'])
    params = QueryDict('', mutable=True)
    params['utm_source'] = 'rasp'
    if utm_medium:
        params['utm_medium'] = utm_medium
    if utm_campaign:
        params['utm_campaign'] = utm_campaign
    if day:
        params['when'] = day.strftime('%Y-%m-%d')
    return 'https://{host}/flights/{thread}/?{params}'.format(
        host=host,
        thread=quote(thread.number.replace(' ', '-').encode('utf-8'), safe=''),
        params=params.urlencode()
    )
