# -*- coding: utf-8 -*-

from datetime import date

from common.models.geo import Settlement, Station
from common.utils.geo import great_circle_distance_km, GreatCircleCalculationError


BLABLACAR_MIN_DISTANCE_KM = 100
BLABLACAR_MAX_DISTANCE_KM = 2000

# Фиктивная дата для поиска блаблакара "на все дни".
BLABLACAR_ALL_DAYS_DATE = date(2100, 1, 1)


def is_valid_blablacar_direction(point_from, point_to):
    if not (isinstance(point_from, (Settlement, Station)) and isinstance(point_to, (Settlement, Station))):
        return False

    try:
        distance_km = great_circle_distance_km(point_from, point_to)
    except GreatCircleCalculationError:
        return False

    return BLABLACAR_MIN_DISTANCE_KM <= distance_km <= BLABLACAR_MAX_DISTANCE_KM
