# coding: utf-8

from django.conf.urls import url
from django.http import HttpResponseNotFound, HttpResponseServerError, HttpResponseForbidden


def handler400(request):
    return HttpResponseForbidden("400 Bad Request", content_type="text/plain")


def handler403(request):
    return HttpResponseForbidden("403 Forbidden", content_type="text/plain")


def handler404(request):
    return HttpResponseNotFound("404 Not Found", content_type="text/plain")


def handler500(request):
    return HttpResponseServerError("500 Server Error", content_type="text/plain")


handler_test_patterns = [
    url(r'^400\.html$', handler400),
    url(r'^403\.html$', handler403),
    url(r'^404\.html$', handler404),
    url(r'^500\.html$', handler500),
]
