# coding: utf-8
from __future__ import unicode_literals

from copy import deepcopy

import six


class FieldMasker(object):
    def __init__(self, mask_fields=None, mask_char='*', max_mask_length=15):
        self.mask_fields = mask_fields
        self.mask_char = mask_char
        self.max_mask_length = max_mask_length

    def apply(self, data):
        if not self.mask_fields:
            return data
        result = deepcopy(data)
        return self._apply_step(result, self.mask_fields)

    def _apply_step(self, data, mask):
        if isinstance(data, list) and isinstance(mask, list):
            item_mask = mask[0]
            return [self._apply_step(item, item_mask) for item in data]
        if isinstance(data, dict) and isinstance(mask, dict):
            for field, field_mask in mask.items():
                value = data.get(field)
                if value is None:
                    continue
                else:
                    data[field] = self._apply_step(value, field_mask)
            return data
        elif isinstance(mask, dict):
            return data
        else:
            value = six.text_type(data)
            if len(value) > self.max_mask_length:
                return '{0}{0}{0}..'.format(self.mask_char)
            else:
                return self.mask_char * len(value)
