# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import locale
from functools import total_ordering


@total_ordering
class CollateUnicode():
    def __init__(self, str):
        self.str = str

    def __lt__(self, other):
        return locale.strcoll(self.str, other.str) < 0

    def __eq__(self, other):
        return locale.strcoll(self.str, other.str) == 0
