# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
from datetime import date, datetime, time, timedelta

try:
    from hemi import undefined
except ImportError:
    undefined = None


def rich_serialize(obj):
    if hasattr(obj, '__json__'):
        return obj.__json__()

    if isinstance(obj, datetime):
        return obj.strftime("%Y-%m-%d %H:%M:%S")

    if isinstance(obj, date):
        return obj.strftime("%Y-%m-%d")

    if isinstance(obj, timedelta):
        return obj.seconds + obj.days * 84600

    if isinstance(obj, time):
        return obj.strftime('%H:%M')

    if undefined is not None:
        if obj is undefined:
            return 'NONJSON:undefined'

    raise TypeError(repr(obj) + " is not JSON serializable")


def serialize(obj):
    if hasattr(obj, '__json__'):
        return obj.__json__()

    import hemi

    if obj is hemi.undefined:
        return 'NONJSON:undefined'

    raise TypeError(repr(obj) + " is not JSON serializable")


def hemi_json_debug_dumps(obj, serialize=serialize):
    return json.dumps(obj, default=serialize, ensure_ascii=False, indent=4, separators=(',', ': '),
                      sort_keys=True)


# Не нужно использовать этот json_debug_dumps
json_debug_dumps = hemi_json_debug_dumps
