# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import math
from random import random


def round_dispersed(value, precision=0):
    magnitude = 10. ** precision
    lower = math.floor(value * magnitude) / magnitude
    upper = lower + 1. / magnitude

    return upper if random() > magnitude * (upper - value) else lower


def test_round_dispersed():
    probes = list(range(10**5))

    assert round_dispersed(5) == 5
    assert set([round_dispersed(5.111) for j in probes]) == set([5, 6])
    assert all([round_dispersed(3.14, 2) == 3.14 for j in probes])
    assert set([round_dispersed(3.1415, 2)
                for j in probes]) == set([3.14, 3.15])

    values = [round_dispersed(3.14159, 2) for j in probes]
    assert abs(sum(values) / len(values) - 3.14159) < .01
