# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import hashlib
import logging

from django.conf import settings


log = logging.getLogger(__name__)


# Mandatory access control
def order_data_mac(order_data):
    data = [order_data.get(field)
            for field in settings.ORDER_DATA_MAC_FIELDS]

    data = [d for d in data if d]

    log.debug('order_data_mac: %s', data)

    if not data:
        return None

    m = hashlib.md5()

    for value in data:
        m.update(('%s' % value).encode('utf-8'))

    m.update(settings.SECRET_SALT)

    return m.hexdigest()[:8]


def signed_order_data(order_data):
    order_data = order_data.copy()

    mac = order_data_mac(order_data)

    if mac:
        order_data['digest'] = mac

    return order_data


def check_order_data_digest(order_data):
    computed_mac = order_data_mac(order_data)

    log.debug('start check_order_data_digest: computed_mac: [%s]', computed_mac)

    if not computed_mac:
        return True

    try:
        received_mac = order_data['digest']
    except KeyError:
        log.debug('no received mac')
        return False

    log.debug('received_mac: [%s]' % received_mac)

    return received_mac == computed_mac
