# coding: utf-8

from common.importinfo.models import Express2Country
from common.models.geo import Station, Country
from common.utils.date import MSK_TZ, get_pytz


def get_railway_tz_by_express_code(express_code):
    timezone = Express2Country.get_tz(express_code)
    if timezone:
        return get_pytz(timezone)


def get_railway_tz_by_point(point):
    if isinstance(point, Station):
        express_code = point.get_code('express')
        tz = get_railway_tz_by_express_code(express_code)
        if tz:
            return tz

    if isinstance(point, Country):
        railway_tz_city = point.get_railway_tz_city()
    elif point.country_id:
        railway_tz_city = point.country.get_railway_tz_city()
    else:
        railway_tz_city = None

    if railway_tz_city:
        return railway_tz_city.pytz
    else:
        return MSK_TZ
