# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function
"""
Методы django.Request, который зависят от наших настроек nginx
"""

from django.conf import settings
from six.moves.urllib.parse import urlsplit

from common.settings.configuration import Configuration
from common.settings.utils import define_setting


define_setting('REMOTE_ADDR_META_VARIABLE', default='HTTP_X_REAL_IP')
define_setting('REMOTE_ADDR_META_VARIABLE_FALLBACK', default=None, env={
    Configuration.DEVELOPMENT: 'REMOTE_ADDR'
})
define_setting('REMOTE_ADDR_GET_PARAM', default=None)
define_setting('HOST_META_VARIABLE', default='HTTP_X_REAL_HOST')


def get_host(request):
    return request.META.get(settings.HOST_META_VARIABLE, request.get_host())


def build_absolute_uri(request, location=None):
    uri = request.build_absolute_uri(location)
    return urlsplit(uri)._replace(netloc=get_host(request)).geturl()


def get_ip(request):
    if settings.REMOTE_ADDR_GET_PARAM and request.GET.get(settings.REMOTE_ADDR_GET_PARAM):
        return request.GET[settings.REMOTE_ADDR_GET_PARAM]
    if request.META.get(settings.REMOTE_ADDR_META_VARIABLE):
        return request.META[settings.REMOTE_ADDR_META_VARIABLE]
    if request.META.get(settings.REMOTE_ADDR_META_VARIABLE_FALLBACK):
        if settings.REMOTE_ADDR_META_VARIABLE_FALLBACK != settings.REMOTE_ADDR_META_VARIABLE:
            return request.META[settings.REMOTE_ADDR_META_VARIABLE_FALLBACK]
    return None
