# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import json

from common.db.mysql_info import get_mysql_info, render_mysql_info
from django.http import HttpResponse


def db_info(request):
    """
    Информация о настройках mysql-кластеров и текущих соединениях.
    Эта ручка должна быть доступна ТОЛЬКО из внутренних сетей.

    Если балансер сервиса открыт наружу, нужно делать проверку на ровне nginx, например:
    https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/export/docker/nginx/app.conf?rev=5520443#L73-76
    """
    if request.GET.get('format') == 'json':
        db_info = get_mysql_info()
        response = json.dumps(db_info, indent=4)
        return HttpResponse(response, content_type="application/json")
    else:
        return HttpResponse(render_mysql_info(), content_type="text/plain")
