# -*- coding: utf-8 -*-

from django.conf import settings

from common.models.geo import Settlement, Station
from common.models.transport import TransportType


def get_biggest_cities(country, amount=settings.CITIES_IN_COUNTRY_SEARCH):
    u"""Формирование списка самых крупных городов по загруженности аэропортов"""

    cities = list(Settlement.hidden_manager.filter(country=country).order_by('-threads_amount')[:amount])
    cities = [c for c in cities if not c.disputed_territory]

    stations = Station.objects.filter(
        settlement__in=cities, t_type=TransportType.PLANE_ID, hidden=False
    ).order_by('title')
    # Если не нашли аэропортов, то ищем станции с любым типом транспорта
    if not stations:
        stations = Station.objects.filter(settlement__in=cities, hidden=False).order_by('title')
    results = {}
    for s in stations:
        results.setdefault(s.settlement.id, []).append(s)

    return [(city, results[city.id]) for city in cities if city.id in results]
