# -*- coding: utf-8


class StaticTariffPlace(object):
    code = None
    name = None

    def __init__(self, tariff, name=None, is_min_tariff=False):
        self.tariff = tariff
        self.name = name
        self.min = is_min_tariff


class StaticTariffPlaceLinked(StaticTariffPlace):
    def get_params(self, segment, point_from, point_to):
        params = {
            'station_from': segment.station_from.id,
            'station_to': segment.station_to.id,
            'departure': segment.msk_departure.replace(tzinfo=None),
            'arrival': segment.msk_arrival.replace(tzinfo=None),
            'title': segment.title,
            'date': segment.departure.date(),
            'number': segment.number,
            't_type': segment.t_type.code,
        }

        if segment.thread:
            params['thread'] = segment.thread.uid

        if point_from and point_to:
            params.update({
                'point_from': point_from.point_key,
                'point_to': point_to.point_key,
            })

        params.update({
            'tariff': self.tariff,
        })

        return params

    def link(self, request, segment, buy_link_func, point_from=None, point_to=None):
        params = self.get_params(segment, point_from, point_to)

        return buy_link_func(request, params)


class StaticTariffPlaceOrder(StaticTariffPlace):
    def __init__(self, tariff, order_url, name=None, metrika=None, is_min_tariff=False):
        super(StaticTariffPlaceOrder, self).__init__(tariff, name, is_min_tariff)
        self.order_url = order_url
        self.metrika = metrika

    def link(self, *args, **kwargs):
        return self.order_url


class StaticTariffs(object):
    dynamic = False
    et_marker = False
    wait = False

    def __init__(self, tariff, name=None, places=None, linked=False, order_data=None, is_min_tariff=False):
        if places:
            self.places = places

        elif linked:
            self.places = [StaticTariffPlaceLinked(tariff, name, is_min_tariff)]

        else:
            self.places = [StaticTariffPlace(tariff, name, is_min_tariff)]

        self.order_data = order_data


class AuxTariffs(dict):
    def __init__(self, base):
        self.base = base


class DisplayInfo(dict):
    def __init__(self, *args, **kwargs):
        super(DisplayInfo, self).__init__(*args, **kwargs)

        self['js_classes'] = []

    def add_class(self, cls):
        self['js_classes'].append(cls)

    def hide(self):
        self['hidden'] = True

    def set_tariff(self, tariff, **kwargs):
        self['tariffs_info'] = StaticTariffs(tariff, **kwargs)

    def set_aux_tariffs(self, tariffs, base_code):
        base = tariffs[base_code]

        aux_tariffs = AuxTariffs(base)

        for t in sorted(tariffs.values(), key=lambda t: t.type.order):
            aux_tariffs.setdefault(t.type.category, []).append(t)

        self['aux_tariffs'] = aux_tariffs

    @property
    def tariffs_info(self):
        return self.get('tariffs_info')

    @property
    def data(self):
        return self.get('data')

    @property
    def aux_tariffs(self):
        return self.get('aux_tariffs')

    @property
    def hidden(self):
        return self.get('hidden')
