#!/bin/bash

set -e
shopt -s nullglob

if hash virtualenv2 2>/dev/null; then
    virtualenv=virtualenv2
else
    virtualenv=virtualenv
fi

cd $(dirname $0)

echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "!!!!!!! PLEASE USE ./common/virtualenv-setup.py !!!!!!!!!!"
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"

get_requirements() {
    for r in ../*/requirements.txt
    do
        cat $r
    done
}

get_dev_requirements() {
    for r in ../*/dev_requirements.txt
    do
        cat $r
    done
}

tmp_requirements=$(mktemp --suffix requirements.txt)
tmp_nodeps_requirements=$(mktemp --suffix requirements_nodeps.txt)

{
    get_requirements
    if [ "$1" == "--dev" ]; then
        get_dev_requirements
    fi
} | sort | uniq > $tmp_requirements

{
    for r in ../*/requirements_nodeps.txt
    do
        cat $r
    done
} | sort | uniq > $tmp_nodeps_requirements

{
    rm -rf virtualenv
    ${virtualenv} virtualenv --system-site-packages --no-setuptools

    virtualenv/bin/python virtualenv/bin/pip install --upgrade pip~=9.0 setuptools~=37.0
    virtualenv/bin/python virtualenv/bin/pip install  -I -r $tmp_requirements
    virtualenv/bin/python virtualenv/bin/pip install  -I --no-deps -r $tmp_nodeps_requirements
}

rm -f $tmp_requirements
rm -f $tmp_nodeps_requirements
