# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import time

from travel.rasp.library.python.common23.date.environment import now_utc
from common.workflow.process import StateAction, ActionResult
from common.workflow.utils import get_by_dotted_path


class SleepEvents(object):
    OK = 'ok'


class Sleep(StateAction):
    idempotent = True

    def do(self, _data, seconds):
        time.sleep(seconds)
        return SleepEvents.OK


class SleepTill(StateAction):
    def do(self, _data, path_to_attr_till):
        sleep_till = get_by_dotted_path(self.document, path_to_attr_till, default=None)
        if sleep_till:
            seconds = (sleep_till - now_utc()).total_seconds()
            if seconds > 0:
                time.sleep(seconds)
        return SleepEvents.OK


class WaitTillStatuses(object):
    OK = 'ok'


class WaitAction(StateAction):
    def do(self, data, wait_interval):
        wait_till = now_utc() + wait_interval
        return ActionResult(WaitTillStatuses.OK, wait_till=wait_till)
