PY2_LIBRARY(common)

OWNER(
    g:rasp-back
)

PEERDIR(
    contrib/python/apispec/py2
    contrib/python/cachetools
    contrib/python/celery
    contrib/python/contextlib2
    contrib/python/dateutil
    contrib/python/decorator
    contrib/python/djangorestframework
    contrib/python/django-redis
    contrib/python/factory-boy
    contrib/python/gevent
    contrib/python/iso8601
    contrib/python/ipython
    contrib/python/marshmallow/py2
    contrib/python/marshmallow-enum/py2
    contrib/python/mongolock
    contrib/python/pathlib2
    contrib/python/Pillow
    contrib/python/Pygments
    contrib/python/pyOpenSSL
    contrib/python/redis

    contrib/python/requests
    contrib/python/sentry-sdk

    geobase/python/static

    ydb/public/sdk/python
    kikimr/public/sdk/python/persqueue  # errorboosterclient.logbroker.LogbrokerClient

    library/python/blackbox
    library/python/cookiemy
    library/python/django

    library/python/python-django-tanker

    travel/library/python/avia_mdb_replica_info
    travel/library/python/base_http_client
    travel/library/python/logbroker
    travel/library/python/tvm_ticket_provider
    travel/library/python/tracing/instrumentation

    travel/proto/dicts/avia

    travel/rasp/library/python/api_clients/baris
    travel/rasp/library/python/api_clients/deploy_public_api
    travel/rasp/library/python/api_clients/dzv
    travel/rasp/library/python/api_clients/im
    travel/rasp/library/python/api_clients/movista
    travel/rasp/library/python/api_clients/redir
    travel/rasp/library/python/api_clients/sandbox
    travel/rasp/library/python/api_clients/sandbox_proxy
    travel/rasp/library/python/api_clients/ticket_daemon
    travel/rasp/library/python/api_clients/travel_api
    travel/rasp/library/python/common/contrib

    travel/rasp/library/python/common23/data_api/error_booster
    travel/rasp/library/python/common23/data_api/juggler
    travel/rasp/library/python/common23/date
    travel/rasp/library/python/common23/db
    travel/rasp/library/python/common23/db/mds
    travel/rasp/library/python/common23/db/mongo
    travel/rasp/library/python/common23/db/mongo/tester
    travel/rasp/library/python/common23/db/redis
    travel/rasp/library/python/common23/dynamic_settings
    travel/rasp/library/python/common23/logging
    travel/rasp/library/python/common23/logging/mongo
    travel/rasp/library/python/common23/middleware
    travel/rasp/library/python/common23/models/core
    travel/rasp/library/python/common23/models/currency
    travel/rasp/library/python/common23/models/fields
    travel/rasp/library/python/common23/models/precache
    travel/rasp/library/python/common23/models/serialization
    travel/rasp/library/python/common23/models/tariffs
    travel/rasp/library/python/common23/models/tariffs/tester
    travel/rasp/library/python/common23/models/texts
    travel/rasp/library/python/common23/models/transport
    travel/rasp/library/python/common23/models/utils
    travel/rasp/library/python/common23/server
    travel/rasp/library/python/common23/settings
    travel/rasp/library/python/common23/utils
    travel/rasp/library/python/common23/utils_db
    travel/rasp/library/python/common23/xgettext

    # TODO: #py23remove. От tester должны зависеть только тесты
    # Сейчас много тестов старых либ зависят от tester через common, поэтому пока оставляем здесь
    travel/rasp/library/python/common23/tester
    travel/rasp/library/python/common23/tester/factories
    travel/rasp/library/python/common23/tester/full_settings
    travel/rasp/library/python/common23/tester/plugins_models

    travel/rasp/library/python/solomon
    travel/rasp/library/python/sqs

    yt/python/client
)

PEERDIR(
    contrib/python/typing
    contrib/python/enum34

    # should be for py3 as well!
    contrib/python/Babel
    contrib/deprecated/python/django-rest-swagger
)

PY_SRCS(
    NAMESPACE common
    __init__.py
    app.py

    app_stubs/__init__.py
    app_stubs/order/__init__.py
    app_stubs/order/models.py
    app_stubs/www/__init__.py
    app_stubs/www/models.py

    apps/__init__.py

    apps/archival_data/__init__.py
    apps/archival_data/app.py
    apps/archival_data/api.py
    apps/archival_data/clean.py
    apps/archival_data/factories.py
    apps/archival_data/generation.py
    apps/archival_data/models.py

    apps/facility/__init__.py
    apps/facility/factories.py
    apps/facility/models.py
    apps/facility/shortcuts.py

    apps/im_logs/__init__.py
    apps/im_logs/models.py

    apps/info_center/__init__.py
    apps/info_center/app.py
    apps/info_center/getter.py
    apps/info_center/models.py
    apps/info_center/push.py
    apps/info_center/yadm_news_item.py

    apps/suburban_events/__init__.py
    apps/suburban_events/api.py
    apps/suburban_events/app.py
    apps/suburban_events/dynamic_params.py
    apps/suburban_events/factories.py
    apps/suburban_events/forecast/__init__.py
    apps/suburban_events/forecast/events.py
    apps/suburban_events/forecast/fact_interpolation.py
    apps/suburban_events/forecast/forecast.py
    apps/suburban_events/forecast/match_cppk.py
    apps/suburban_events/forecast/match_rzd.py
    apps/suburban_events/logs.py
    apps/suburban_events/models.py
    apps/suburban_events/scripts/__init__.py
    apps/suburban_events/scripts/calc_suburban_keys.py
    apps/suburban_events/scripts/clean.py
    apps/suburban_events/scripts/precalc_thread_events.py
    apps/suburban_events/scripts/update_companies_crashes.py
    apps/suburban_events/scripts/update_movista_matched_cancels.py
    apps/suburban_events/scripts/update_movista_raw_cancels.py
    apps/suburban_events/scripts/update_suburban_events.py
    apps/suburban_events/utils.py

    apps/train/__init__.py
    apps/train/models.py
    apps/train/tariff_error.py

    apps/train_order/__init__.py
    apps/train_order/enums.py
    apps/train_order/models.py

    bin/cron_run.py
    bin/runpy.py

    celery/__init__.py
    celery/app.py
    celery/beat.py
    celery/task.py
    celery/worker.py

    cysix/builder.py

    data_api/__init__.py
    data_api/base.py

    data_api/baris/all_flights.py
    data_api/baris/base_avia_segment.py
    data_api/baris/helpers.py
    data_api/baris/instance.py
    data_api/baris/service.py
    data_api/baris/test_helpers.py

    data_api/billing/__init__.py
    data_api/billing/helpers.py
    data_api/billing/trust_client.py

    data_api/deploy/instance.py

    data_api/dzv/__init__.py
    data_api/dzv/instance.py
    data_api/dzv/platfrom_text_replacer.py

    data_api/file_wrapper/config.py
    data_api/file_wrapper/registry.py
    data_api/file_wrapper/wrappers.py
    data_api/file_wrapper/projects_configs/admin_mds_utils.py

    data_api/im/instance.py

    data_api/movista/instance.py

    data_api/min_prices/__init__.py
    data_api/min_prices/api.py
    data_api/min_prices/factory.py

    data_api/platforms/__init__.py
    data_api/platforms/client.py
    data_api/platforms/helpers.py
    data_api/platforms/instance.py
    data_api/platforms/serialization.py

    data_api/proxy/partners_proxy.py

    data_api/redir/instance.py

    data_api/qloud/__init__.py
    data_api/qloud/api.py
    data_api/qloud/utils.py

    data_api/sandbox/__init__.py
    data_api/sandbox/sandbox_proxy/instance.py
    data_api/sandbox/admin_script_after_run.py
    data_api/sandbox/errors.py
    data_api/sandbox/generate_geometry_resources.py
    data_api/sandbox/generate_livemap.py
    data_api/sandbox/remote_copy_resource_task_runner.py
    data_api/sandbox/run_and_release_task.py
    data_api/sandbox/sandbox_public_api.py
    data_api/sandbox/sandbox_task_runner.py

    data_api/search_stats/__init__.py
    data_api/search_stats/search_stats.py
    data_api/search_stats/search_stats_saver.py

    data_api/sendr/__init__.py
    data_api/sendr/api.py

    data_api/sup/__init__.py
    data_api/sup/client.py
    data_api/sup/config.py

    data_api/ticket_daemon/__init__.py
    data_api/ticket_daemon/serialization/__init__.py
    data_api/ticket_daemon/serialization/avia_partner.py
    data_api/ticket_daemon/serialization/itinerary.py
    data_api/ticket_daemon/serialization/query_qid_poll_params.py
    data_api/ticket_daemon/serialization/query_search_params.py
    data_api/ticket_daemon/serialization/segment.py
    data_api/ticket_daemon/serialization/variant.py
    data_api/ticket_daemon/async_api.py
    data_api/ticket_daemon/factories.py
    data_api/ticket_daemon/instance.py
    data_api/ticket_daemon/jsend.py
    data_api/ticket_daemon/query.py

    data_api/train_api/__init__.py
    data_api/train_api/tariffs/__init__.py
    data_api/train_api/tariffs/utils.py

    data_api/transport_page/__init__.py
    data_api/transport_page/transport_country.py

    data_api/travel_api/instance.py

    data_api/travelers/__init__.py
    data_api/travelers/client.py
    data_api/travelers/instance.py

    data_api/tvm/__init__.py
    data_api/tvm/header_creator.py
    data_api/tvm/instance.py
    data_api/tvm/services.py
    data_api/tvm/transport.py

    data_api/url_shortener/__init__.py
    data_api/url_shortener/client.py

    data_api/utils.py

    data_api/yandex_bus/__init__.py
    data_api/yandex_bus/api.py
    data_api/yandex_bus/config.py
    data_api/yandex_bus/factories.py

    data_api/yasms/__init__.py
    data_api/yasms/client.py

    data_api/ydb/instance.py

    data_api/yt/instance.py
    data_api/yt/yt_lib.py

    db/backends/alias_proxy/base.py
    db/backends/mysql/base.py
    db/backends/dbwrapper_base.py

    db/connect.py

    db/kikimr/__init__.py
    db/kikimr/client.py
    db/kikimr/schedule_conf.py

    db/maintenance.py

    db/mds/__init__.py
    db/mds/base.py
    db/mds/clients.py
    db/mds/s3_storage.py
    db/mds/syncer.py

    db/mysql_info.py

    db/mongo/__init__.py
    db/mongo/base.py
    db/mongo/bulk_buffer.py
    db/mongo/command_logger.py
    db/mongo/counter.py
    db/mongo/fields.py
    db/mongo/mongo.py
    db/mongo/representable.py

    db/sqs/instance.py
    db/switcher.py

    dev_tools/__init__.py
    dev_tools/build.py
    dev_tools/swagger/__init__.py
    dev_tools/swagger/decorator.py
    dev_tools/swagger/endpoint.py
    dev_tools/swagger/spec.py
    dev_tools/swagger/view.py

    # TODO: #py23remove
    dynamic_settings/core.py
    dynamic_settings/default.py

    email_sender/__init__.py
    email_sender/factories.py
    email_sender/models.py
    email_sender/sender.py
    email_sender/tasks.py

    forms/__init__.py
    forms/thread.py

    geotargeting/__init__.py
    geotargeting/lookup.py
    geotargeting/middleware.py
    geotargeting/utils.py

    gunicorn/mds_sync.py

    importinfo/__init__.py
    importinfo/models/__init__.py
    importinfo/models/bus.py

    maintenance/__init__.py
    maintenance/models.py

    management/__init__.py
    management/commands/__init__.py
    management/commands/celery_restart.py
    management/commands/celery_start.py
    management/commands/celery_stop.py
    management/commands/load_db_dump.py
    management/commands/run_path.py

    middleware/__init__.py
    middleware/blackbox_session.py
    middleware/extract_context.py
    middleware/host.py
    middleware/language.py
    middleware/locale_request.py
    middleware/now.py
    middleware/ping.py
    middleware/request_activator.py
    middleware/robot_detector.py
    middleware/syncdb.py
    middleware/uatraits_detector.py
    middleware/url_encoding_hack.py
    middleware/yandexuid.py
    middleware/yateamuser.py
    middleware/yauser.py

    models/__init__.py
    models/compatibility.py
    models/currency.py
    models/disclaimers.py
    models/factories.py
    models/geo.py
    models/partner.py
    models/pathfinder_maps.py
    models/schedule.py
    models/special_tariffs.py
    models/staticpages.py
    models/tariffs.py
    models/teasers.py
    models/timestamp.py
    models/transport.py

    models_abstract/__init__.py
    models_abstract/geo.py
    models_abstract/schedule.py
    models_abstract/tariffs.py

    models_admin/geo.py
    models_admin/schedule.py

    models_utils/__init__.py
    models_utils/geo.py
    models_utils/i18n.py

    precache/backend.py
    precache/manager.py
    precache/proxy_slots.py
    precache/storage.py

    serialization/common_schemas.py
    serialization/fields.py
    serialization/schema.py

    # TODO: #py23remove
    settings/__init__.py
    settings/configuration/__init__.py
    settings/db.py
    settings/utils.py

    tester/__init__.py
    tester/admin/__init__.py
    tester/admin/django_auth.py
    tester/factories.py

    # TODO: #py23remove
    tester/initializer.py
    tester/matchers.py
    tester/mocks.py
    tester/settings.py
    tester/settings_for_old_libs.py
    tester/skippers.py
    tester/testcase.py
    tester/transaction_context.py
    tester/utils/datetime.py
    tester/utils/django_cache.py
    tester/utils/logging.py
    tester/utils/mongo.py
    tester/utils/replace_setting.py
    tester/utils/replace_dynamic_setting.py
    tester/yaml_fixtures.py
    tester/yaml_serializer.py

    test_utils/__init__.py
    test_utils/workflow.py

    utils/__init__.py
    utils/admindumps.py
    utils/avia.py
    utils/banner_provider.py
    utils/bemhtml/__init__.py
    utils/bemhtml/template.py
    utils/blablacar_utils.py
    utils/blackbox_wrapper.py
    utils/caching.py
    utils/calendar_matcher.py
    utils/currency_converter.py
    utils/date.py
    utils/dateparser.py
    utils/dcutils.py  # TODO: #py23remove
    utils/django_utils/__init__.py
    utils/django_utils/utf8_json_serializer.py
    utils/dump.py
    utils/download_file.py
    utils/errorhandlers.py
    utils/exceptions.py
    utils/field_masker.py
    utils/fields.py
    utils/files/__init__.py
    utils/files/storage.py
    utils/files/validators.py
    utils/fileutils.py
    utils/geo.py
    utils/geobase.py
    utils/http.py
    utils/httpcaching.py
    utils/httpresponses.py
    utils/i18n.py
    utils/iterrecipes.py
    utils/jsonutils.py
    utils/locations.py
    utils/lock.py
    utils/lxmlutils.py
    utils/marketstat.py
    utils/mathematic.py
    utils/metrics.py
    utils/models.py
    utils/multiproc.py
    utils/mysql_try_hard.py
    utils/namedtuple.py
    utils/order_data.py
    utils/ping.py
    utils/point_slugs.py
    utils/progress.py
    utils/railway.py
    utils/redirect.py
    utils/regexp.py
    utils/request_helper.py
    utils/request_limiter.py
    utils/safe_xml_parser.py
    utils/settlement.py
    utils/subprocess.py
    utils/tanker.py
    utils/text.py
    utils/threadutils.py
    utils/title_generator.py
    utils/tracer.py
    utils/try_hard.py
    utils/tz_mask_split.py
    utils/unicode_csv.py
    utils/warnings.py  # TODO: #py23remove
    utils/weather.py
    utils/ya.py
    utils/yandexmaps.py
    utils/yasmutil.py

    views/__init__.py
    views/db_info.py
    views/currency.py
    views/settlement.py
    views/tariffs.py
    views/teasers.py
    views/thread.py
    views/thread_search.py
    views/timezones.py
    views/version.py

    workflow/__init__.py
    workflow/errors.py
    workflow/locker.py
    workflow/process.py
    workflow/registry.py
    workflow/reviver.py
    workflow/scheme.py
    workflow/sleep.py
    workflow/tests_utils/__init__.py
    workflow/tests_utils/dummy_locker.py
    workflow/tests_utils/process.py
    workflow/utils.py

    xgettext/__init__.py
    xgettext/common.py
    xgettext/i18n.py
    xgettext/management/__init__.py
    xgettext/management/commands/__init__.py
    xgettext/management/commands/base.py
    xgettext/management/commands/tankerdownload.py
    xgettext/management/commands/tankerupload.py
)

IF(PYTHON3)
    PY_SRCS(
        # insert files here
    )
ENDIF()

RESOURCE_FILES(
    PREFIX common/

    # keysets
    xgettext/keyset.json

    # fixtures
    fixtures/train_coach_type_initial.json
    fixtures/train_facility_initial.json

    # maintenance fixtures
    maintenance/fixtures/maintenance_flag_initial.json
)

END()

RECURSE(
    apps/facility/migrations
    apps/suburban_events/migrations
    apps/train/migrations
    apps/train_order/migrations
    contrib
    maintenance/migrations
)

RECURSE_FOR_TESTS(
    tests
)
