# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


class HostInfo(object):
    def __init__(self, host, data_center):
        # type: (unicode, unicode) -> None
        self.host = host
        self.data_center = data_center

    def __repr__(self):
        # type: () -> unicode
        return '<HostInfo host={} data_center={}/>'.format(
            self.host,
            self.data_center
        )

    def __eq__(self, other):
        # type: (HostInfo) -> bool
        if isinstance(self, other.__class__):
            return self.host == other.host and self.data_center == other.data_center

        return False
