# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import random
from logging import Logger, getLogger  # noqa
from typing import List, Tuple  # noqa

from django.conf import settings


class HostSorter(object):
    def __init__(self, current_dc, logger):
        # type: (unicode, Logger) -> None
        self._current_dc = current_dc
        self._logger = logger

    def _get_order(self):
        # type: () -> List[unicode]

        def shuffle(items):
            items = list(items)
            random.shuffle(items)
            return items

        moscow_dc = ['iva', 'myt']

        dc_to_order = {
            'man': ['man'] + shuffle(moscow_dc) + ['sas', 'vla'],
            'iva': ['iva', 'myt', 'sas', 'vla', 'man'],
            'myt': ['myt', 'iva', 'sas', 'vla', 'man'],
            'sas': ['sas', 'vla'] + shuffle(moscow_dc) + ['man'],
            'vla': ['vla', 'sas'] + shuffle(moscow_dc) + ['man'],
        }

        dc = self._current_dc
        if dc not in dc_to_order:
            self._logger.critical("Can not find information about [%s] data center", dc)
            dc = 'sas'

        return dc_to_order[dc]

    def sort(self, host_infos):
        # type: (List[HostInfo]) -> List[HostInfo]
        order = self._get_order()

        def sort_key(host_info):
            # type: (HostInfo) -> Tuple[int, unicode, int]
            try:
                ind = order.index(host_info.data_center)
            except ValueError:
                self._logger.critical("Can not find information about [%s] data center", host_info.data_center)
                ind = len(host_infos)

            return ind, host_info.data_center, random.random()

        return sorted(host_infos, key=sort_key)


host_sorter = HostSorter(
    settings.YANDEX_DATA_CENTER, getLogger(__name__)
)
