# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.data_api.dbaas.client import DbaasClient
from travel.rasp.library.python.common23.data_api.dbaas.host_sorter import host_sorter

from travel.rasp.library.python.common23.settings.utils import define_setting


define_setting('DBAAS_OAUTH_TOKEN', default=get_secret('rasp-common.DBAAS_OAUTH_TOKEN'))
define_setting('DBAAS_API_URL', default='gw.db.yandex-team.ru')


dbaas_client = DbaasClient(
    oauth_token=settings.DBAAS_OAUTH_TOKEN,
    api_url=settings.DBAAS_API_URL,
    host_sorter=host_sorter,
    root_cert_file=settings.INTERNAL_ROOT_CERT,
)
