# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from travel.rasp.library.python.common23.utils.dcutils import ResourceExplorer


def get_env_params():
    if ResourceExplorer.is_run_in_qloud():
        return {
            'project': os.getenv('QLOUD_PROJECT'),
            'application': os.getenv('QLOUD_APPLICATION'),
            'env': os.getenv('QLOUD_ENVIRONMENT'),
            'component': os.getenv('QLOUD_COMPONENT'),
            'host': os.getenv('QLOUD_HOSTNAME')
        }
    elif ResourceExplorer.is_run_in_deploy():
        return {
            'project': os.getenv('TRAVEL_DEPLOY_PROJECT'),
            'application': os.getenv('TRAVEL_DEPLOY_APPLICATION'),
            'env': os.getenv('TRAVEL_DEPLOY_ENVIRONMENT'),
            'component': os.getenv('TRAVEL_DEPLOY_UNIT'),
            'host': os.getenv('TRAVEL_DEPLOY_HOST')
        }
    else:
        return {}
