# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from travel.rasp.library.python.common23.settings.utils import define_setting

from travel.rasp.library.python.common23.data_api.juggler.env_params import get_env_params
from travel.library.python.base_http_client import CircuitBreakerConfig, RetryConfig
from travel.rasp.library.python.api_clients.juggler import JugglerClient
from travel.rasp.library.python.api_clients.juggler.client import JUGGLER_HOST

current_env = get_env_params()
JUGGLER_DEFAULT_SOURCE = '{}.{}.{}.{}'.format(
    current_env.get('project'),
    current_env.get('application'),
    current_env.get('env'),
    current_env.get('component')
)

define_setting('JUGGLER_API_SOURCE', default=JUGGLER_DEFAULT_SOURCE)
define_setting('JUGGLER_API_HOST', default=JUGGLER_HOST)
define_setting('JUGGLER_API_TIMEOUT', default=5)
define_setting('JUGGLER_CIRCUIT_BREAKER_PARAMS', default={'fail_max': 3, 'reset_timeout': 5})
define_setting('JUGGLER_RETRY_PARAMS', default={'total': 2, 'backoff_factor': 0.1, 'method_whitelist': ['POST']})


juggler_client = JugglerClient(
    source=settings.JUGGLER_API_SOURCE,
    host=settings.JUGGLER_API_HOST,
    timeout=settings.JUGGLER_API_TIMEOUT,
    circuit_breaker_config=CircuitBreakerConfig(**settings.JUGGLER_CIRCUIT_BREAKER_PARAMS),
    retry_config=RetryConfig(**settings.JUGGLER_RETRY_PARAMS)
)
