# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import tempfile

from django.conf import settings

from rasp_vault.api import get_secret

from travel.rasp.library.python.api_clients.mdb import MdbApiWrapper, MYSQL_API_BASE_URL, MONGO_API_BASE_URL, REDIS_API_BASE_URL

from travel.rasp.library.python.common23.settings.configuration import Configuration
from travel.rasp.library.python.common23.settings.utils import define_setting


define_setting(
    'MDB_OAUTH_TOKEN',
    default=None,
    env={
        Configuration.TESTING: lambda: get_secret('rasp-common.MDB_OAUTH_TOKEN'),
        Configuration.PRODUCTION: lambda: get_secret('rasp-common.MDB_OAUTH_TOKEN')
    }
)
define_setting('MDB_CACHE_FOLDER', default='{}/mdb_api_cache'.format(tempfile.gettempdir()))


mdb_mysql_api = MdbApiWrapper(
    api_base_url=MYSQL_API_BASE_URL,
    oauth_token=settings.MDB_OAUTH_TOKEN,
    cache_folder=settings.MDB_CACHE_FOLDER,
)

mdb_mongo_api = MdbApiWrapper(
    api_base_url=MONGO_API_BASE_URL,
    oauth_token=settings.MDB_OAUTH_TOKEN,
    cache_folder=settings.MDB_CACHE_FOLDER,
)

mdb_redis_api = MdbApiWrapper(
    api_base_url=REDIS_API_BASE_URL,
    oauth_token=settings.MDB_OAUTH_TOKEN,
    cache_folder=settings.MDB_CACHE_FOLDER,
)
