# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
from datetime import datetime
from distutils.util import strtobool
from threading import local

import pytz
from django.conf import settings
from django.utils.translation import get_language

from travel.rasp.library.python.common23.date.date_const import MSK_TZ


_time_context = local()


def set_time_context(value):
    _time_context.naive_msk_now = value


def get_time_context():
    return getattr(_time_context, 'naive_msk_now', None)


def delete_time_context():
    if hasattr(_time_context, 'naive_msk_now'):
        del _time_context.naive_msk_now


def get_freezed_time():
    naive_msk_now = get_time_context()
    if not naive_msk_now:
        naive_msk_now = getattr(settings, 'ENVIRONMENT_NOW', None)
    return naive_msk_now


def today():
    return now().date()


def now():
    # ultimate_now вызывает now_aware.
    # Поэтому при наличии времени в _time_context или ENVIRONMENT_NOW оно будет использовано.
    return ultimate_now()


def ultimate_now():
    """
    На случай, если время начала запроса будет не достаточно
    """

    return now_aware().replace(tzinfo=None)


def now_aware():
    naive_msk_now = get_freezed_time()
    return MSK_TZ.localize(naive_msk_now) if naive_msk_now else pytz.UTC.localize(datetime.utcnow()).astimezone(MSK_TZ)


def now_utc(aware=False):
    utc_aware = now_aware().astimezone(pytz.UTC)
    return utc_aware if aware else utc_aware.replace(tzinfo=None)


def get_locale():
    request = get_request()

    return u"%s_%s" % (get_language(), request.NATIONAL_VERSION.upper()) if request else get_language()


_active = local()


def get_request():
    return getattr(_active, "value", None)


def activate_request(request):
    _active.value = request


def deactivate_request():
    if hasattr(_active, "value"):
        del _active.value


def is_migration_allowed():
    return bool(strtobool(os.environ.get('RASP_MIGRATION_ALLOWED', 'false')))
