# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.conf import settings
from django.core.files.storage import get_storage_class
from storages.backends.s3boto3 import S3Boto3Storage

from travel.rasp.library.python.common23.db.mds.settings import *  # noqa
from travel.rasp.library.python.common23.settings.configuration import Configuration
from travel.rasp.library.python.common23.settings.utils import define_setting


define_setting('MDS_RASP_MEDIA_BUCKET', {
    Configuration.PRODUCTION: 'rasp',
    Configuration.TESTING: 'rasp-test-media-bucket',
}, default='rasp-test-media-bucket')

define_setting('MDS_MEDIA_LOCATION', default='media/')

define_setting('MDS_MEDIA_CUSTOM_DOMAIN', {
    Configuration.PRODUCTION: 'yastat.net/s3/rasp'
}, default='rasp-test-media-bucket.s3.yandex.net')

# https://a.yandex-team.ru/arc/trunk/arcadia/contrib/python/django-storages/storages/backends/s3boto3.py?rev=r7671039#L339
define_setting('AWS_DEFAULT_ACL', default='public-read')


class MdsS3Storage(S3Boto3Storage):
    bucket_name = settings.MDS_RASP_MEDIA_BUCKET
    access_key = settings.MDS_ACCESS_KEY_ID
    secret_key = settings.MDS_ACCESS_SECRET_KEY
    endpoint_url = settings.MDS_URL
    location = settings.MDS_MEDIA_LOCATION
    custom_domain = settings.MDS_MEDIA_CUSTOM_DOMAIN
    auto_create_bucket = False


if not settings.MDS_URL:
    # для тестов и дева
    mds_s3_media_storage = get_storage_class()()
else:
    mds_s3_media_storage = MdsS3Storage()
