# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.settings.configuration import Configuration
from travel.rasp.library.python.common23.settings.utils import define_setting


define_setting('MDS_URL', default='http://s3.mds.yandex.net')

define_setting('MDS_RASP_PUBLIC_BUCKET', {
    Configuration.PRODUCTION: 'rasp',
    Configuration.TESTING: 'rasp-test-bucket',
    Configuration.DEVELOPMENT: 'rasp-test-bucket',
}, default=None)  # Не включаем в стрессе продовый, т.к. он публичный

define_setting('MDS_RASP_COMMON_BUCKET', {
    Configuration.PRODUCTION: 'rasp-bucket',
    Configuration.TESTING: 'rasp-test-bucket',
    Configuration.DEVELOPMENT: 'rasp-test-bucket',
    Configuration.STRESS: 'rasp-bucket',
}, default=None)

define_setting('MDS_RASP_INFRA_BUCKET', default='rasp-infra')

define_setting('MDS_ENABLE_WRITING', {
    Configuration.PRODUCTION: True,
    Configuration.TESTING: True,
}, default=False)

define_setting('MDS_CONNECT_TIMEOUT', default=1)
define_setting('MDS_READ_TIMEOUT', default=10)
define_setting('MDS_RETRIES_MAX_ATTEMPTS', default=1)

define_setting('MDS_ACCESS_KEY_ID', default=lambda: get_secret('rasp-common.MDS_ACCESS_KEY_ID'))
define_setting('MDS_ACCESS_SECRET_KEY', default=lambda: get_secret('rasp-common.MDS_ACCESS_SECRET_KEY'))
