# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from threading import local

from pymongo import monitoring

log = logging.getLogger(__name__)


class CommandLogger(monitoring.CommandListener):
    storage = local()

    def started(self, event):
        pass

    def add_time(self, duration):
        try:
            self.storage.cumulative_time += duration
        except AttributeError:
            self.storage.cumulative_time = duration

    def succeeded(self, event):
        command_name = event.command_name
        duration = event.duration_micros / 1e6
        log.debug('%s succeeded using %s', command_name, event.connection_id,
                  extra={'command_name': command_name, 'duration': duration})
        self.add_time(duration)

    def failed(self, event):
        command_name = event.command_name
        duration = event.duration_micros / 1e6
        log.debug('%s failed using %s', command_name, event.connection_id,
                  extra={'command_name': command_name, 'duration': duration})
        self.add_time(duration)

    @classmethod
    def get_cumulative_time(cls):
        return getattr(cls.storage, 'cumulative_time', 0)

    @classmethod
    def get_cumulative_time_and_reset(cls):
        ct = cls.get_cumulative_time()
        cls.storage.cumulative_time = 0
        return ct
